

import static org.junit.Assert.*;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * test class SudokuTest - geef hier een beschrijving van deze class
 *
 * @author (jouw naam)
 * @version (versie nummer of datum)
 */
public class SudokuTest
{
    private Sudoku sudoku1;
    private Sudoku sudoku2;
    private Sudoku sudoku3;
    private Sudoku sudoku4;
    private Sudoku sudoku5;
    private Sudoku sudoku6;

    /**
     * Constructor voor test class SudokuTest
     */
    public SudokuTest()
    {
    }

    /**
     * Opzetten van de test fixture.
     *
     * Aanroep voor elke test case method.
     */
    @Before
    public void setUp()
    {
        sudoku1 = new Sudoku(74, 1);
        sudoku2 = new Sudoku(68, 3);
        sudoku3 = new Sudoku(41, 0);
        sudoku4 = new Sudoku(18, 4);
        sudoku5 = new Sudoku(0, 2);
        sudoku6 = new Sudoku(-14, 6);
    }

    /**
     * Verwijderen van de test fixture.
     *
     * Aanroep na elke test case method.
     */
    @After
    public void tearDown()
    {
    }

    @Test
    public void testGetVolgnummer()
    {
        assertEquals(74, sudoku1.getVolgnummer());
        assertEquals(68, sudoku2.getVolgnummer());
        assertEquals(-1, sudoku3.getVolgnummer());
        assertEquals(-1, sudoku4.getVolgnummer());
        assertEquals(-1, sudoku5.getVolgnummer());
        assertEquals(-1, sudoku6.getVolgnummer());
    }

    @Test
    public void testIsGeldigVolgnummer()
    {
        assertEquals(true, sudoku1.isGeldigVolgnummer());
        assertEquals(true, sudoku2.isGeldigVolgnummer());
        assertEquals(true, sudoku3.isGeldigVolgnummer());
        assertEquals(true, sudoku4.isGeldigVolgnummer());
        assertEquals(false, sudoku5.isGeldigVolgnummer());
        assertEquals(false, sudoku6.isGeldigVolgnummer());
    }

    @Test
    public void testIsGeldigNiveau()
    {
        assertEquals(true, sudoku1.isGeldigNiveau());
        assertEquals(true, sudoku2.isGeldigNiveau());
        assertEquals(false, sudoku3.isGeldigNiveau());
        assertEquals(false, sudoku4.isGeldigNiveau());
        assertEquals(true, sudoku5.isGeldigNiveau());
        assertEquals(false, sudoku6.isGeldigNiveau());
    }


    @Test
    public void testGetNiveau()
    {
        assertEquals(1, sudoku1.getNiveau());
        assertEquals(3, sudoku2.getNiveau());
        assertEquals(-1, sudoku3.getNiveau());
        assertEquals(-1, sudoku4.getNiveau());
        assertEquals(2, sudoku5.getNiveau());
        assertEquals(-1, sudoku6.getNiveau());
    }
}



